#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int highestRound(int N, vector<int>& strengths, int Mi, int Ji) {
    vector<int> cnt(32); 
    for (int i = 0; i < N; ++i) {
        int val = strengths[i] ^ strengths[Mi - 1]; 
        int bits = __builtin_popcount(val); 
        cnt[bits]++;
    }

    int ans = 0;
    for (int i = 0; i < 31; ++i) {
        int rounds = min(cnt[i] / 2, Ji);
        ans += rounds;
        Ji -= rounds;
    }
    return ans;
}

int main() {
    int N;
    cin >> N;

    vector<int> strengths(N);
    for (int i = 0; i < N; ++i) {
        cin >> strengths[i];
    }

    int Q;
    cin >> Q;

    for (int i = 0; i < Q; ++i) {
        int Mi, Ji;
        cin >> Mi >> Ji;

        int maxRounds = highestRound(N, strengths, Mi, Ji);
        cout << maxRounds << endl;
    }

    return 0;
}